/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering.rules;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.entry.filtering.FilteringContext;
import me.shedaniel.rei.api.client.entry.filtering.FilteringResult;
import me.shedaniel.rei.api.client.entry.filtering.FilteringResultFactory;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.entry.filtering.rules.ManualFilteringRuleType;
import me.shedaniel.rei.impl.client.util.ThreadCreator;

public class ManualFilteringRule
implements FilteringRule<LongSet> {
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadCreator("REI-ManualFiltering").asService();

    @Override
    public FilteringRuleType<? extends FilteringRule<LongSet>> getType() {
        return ManualFilteringRuleType.INSTANCE;
    }

    @Override
    public LongSet prepareCache(boolean async) {
        if (async) {
            LongOpenHashSet all = new LongOpenHashSet();
            ArrayList completableFutures = Lists.newArrayList();
            for (Iterable iterable : CollectionUtils.partition(ConfigObject.getInstance().getFilteredStackProviders(), 100)) {
                completableFutures.add(CompletableFuture.supplyAsync(() -> {
                    LongOpenHashSet output = new LongOpenHashSet();
                    for (EntryStackProvider provider : partitionStacks) {
                        if (provider == null || !provider.isValid()) continue;
                        output.add(EntryStacks.hashExact(provider.provide()));
                    }
                    return output;
                }, EXECUTOR_SERVICE));
            }
            try {
                CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(5L, TimeUnit.MINUTES);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
            }
            for (CompletableFuture completableFuture : completableFutures) {
                LongSet now = completableFuture.getNow(null);
                if (now == null) continue;
                all.addAll((LongCollection)now);
            }
            return all;
        }
        return (LongSet)ConfigObject.getInstance().getFilteredStackProviders().stream().filter(EntryStackProvider::isValid).map(provider -> EntryStacks.hashExact(provider.provide())).collect(Collectors.toCollection(LongOpenHashSet::new));
    }

    @Override
    public FilteringResult processFilteredStacks(FilteringContext context, FilteringResultFactory resultFactory, LongSet cache, boolean async) {
        FilteringResult result = resultFactory.create();
        this.processList(context.getShownStacks(), result, async, cache);
        this.processList(context.getUnsetStacks(), result, async, cache);
        return result;
    }

    private void processList(Collection<EntryStack<?>> stacks, FilteringResult result, boolean async, LongSet filteredStacks) {
        result.hide((async ? stacks.parallelStream() : stacks.stream()).filter(stack -> filteredStacks.contains(EntryStacks.hashExact(stack))).collect(Collectors.toList()));
    }
}

